﻿using System;
using System.IO;
using System.Net;
using System.Text;

namespace HttpRequestDemo
{
    class Program
    {
        static void Main()
        {
            const int BufferSize = 2048;

            try
            {
                var AsciiEnc = new ASCIIEncoding();
                var buf = new byte[BufferSize];

                HttpWebRequest httpReq =
                    WebRequest.Create(
                        "http://www.helion.pl")
                    as HttpWebRequest;

                HttpWebResponse httpResp =
                    httpReq.GetResponse() as HttpWebResponse;

                Stream httpStream = httpResp.GetResponseStream();

                int count = httpStream.Read(buf, 0, buf.Length);

                Console.WriteLine(
                    AsciiEnc.GetString(buf, 0, count));
            }
            catch (Exception e)
            {
                Console.WriteLine("Wystąpił błąd: {0}",
                                   e.Message);
            }
        }
    }
}
